\name{createCond}
\alias{createCond}
\title{
Creating a List with Standard Values
}
\description{
\code{createCond} creates a list with standard variables to be used as an input parameter for calculating comfort indices using the function "calcComfInd".
}
\usage{
createCond(a = TRUE)
}
\arguments{
  \item{a}{
logical. If a = TRUE, function returns a list of standard conditions. If a = FALSE, function returns a list of empty variables which may be edited manually. see details for further information.
}
}
\details{

\code{lsstrd} and \code{lsEmpty} contain the following elements
\tabular{llll}{
	Variable name \tab values in \code{lsstrd} \tab values in \code{lsEmpty} \tab description \cr
    ta \tab 25 \tab NA \tab Air temperature in (degree C) \cr
    tr  \tab 25 \tab NA \tab mean radiant temperature in (degree C) \cr
    vel \tab .1 \tab NA \tab Air velocity (m/s) \cr
    rh \tab 50 \tab NA \tab Relative Humidity (\%) \cr
    clo \tab .5 \tab NA \tab clothing (do) \cr
    met \tab 1 \tab NA \tab metabolic rate (met) \cr
    wme \tab 0 \tab NA \tab External work (met) \cr
    tu \tab 40 \tab NA \tab turbulence intensity (\%) \cr
    tmmo \tab 15 \tab NA \tab mean monthly outdoor temperature in (degree C) \cr
    ltime \tab 60 \tab NA \tab Exposure time (min) \cr
    pb \tab 760 \tab NA \tab Barometric pressure (torr) \cr
    wt \tab 70 \tab NA \tab weight (Kg) \cr
    ht \tab 171 \tab NA \tab height (cm) \cr
	trm \tab 15 \tab NA \tab Running mean outdoor temperature in (degree C) \cr
	age \tab 21 \tab NA \tab age (years) \cr
	gender \tab 1 \tab NA \tab gender (female = 1) \cr
	tsk \tab 35 \tab NA \tab mean skin temperature in (degree C) \cr
	psych \tab -1.4 \tab NA \tab factor related to fixed effect on perceived control \cr
	apCoeff \tab .293 \tab NA \tab adaptive coefficient for pmv \cr
	epCoeff \tab .9 \tab NA \tab expectancy factor for pmv \cr
	asCoeff \tab .2 \tab NA \tab adaptive coefficient for set \cr
	esCoeff \tab 1.3 \tab NA \tab expectancy factor for set \cr
	asv \tab 1.5 \tab NA \tab actual sensation vote (0 = neutral) \cr
	tao \tab 5 \tab NA \tab outdoor air temperature \cr
	rho \tab 70 \tab NA \tab outdoor relative humidity \cr
	frad \tab .7 \tab NA \tab 0.7(for seating), 0.73(for standing) [-]  \cr
	eps \tab .95 \tab NA \tab emissivity [-] \cr
	ic \tab 1.085 \tab NA \tab 1.084 (average permeability), 0.4 (low permeability)  \cr
	tcr \tab 37 \tab NA \tab initial values for core temp \cr
	tsk \tab 36 \tab NA \tab initial values for skin temperature \cr
	basMet \tab 58.2 \tab NA \tab basal metabolic rate \cr
	warmUp \tab 60 \tab NA \tab length of warm up period, i.e. number of times, loop is running for HBx calculation \cr
	cdil \tab 100 \tab NA \tab value for cdil in 2-node model of Gagge (applied in calculation of HbEx) \cr
	sigmatr \tab .25 \tab NA \tab value for cdil in 2-node model of Gagge (applied in calculation of HbEx)
}
}
\value{
\item{lsstrd}{List, which is created for a = TRUE; contains standard conditions.}
\item{lsEmpty}{List, which is created for a = FALSE; contains empty variables to be modified manually.}
}
\author{
Sophia Mueller and Marcel Schweiker
}
\seealso{
see also \code{\link{calcComfInd}}
}
\examples{
## Creating list with standard variables
createCond()

## Creating list with empty values
createCond(a = FALSE)

}

\keyword{ manip }
