% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_cluster_averaging.R
\name{combineClusters}
\alias{combineClusters}
\title{Average 3D color histograms by subdirectory}
\usage{
combineClusters(folder, method = "mean", ...)
}
\arguments{
\item{folder}{Path to the folder containing subdirectories of images. Must be
a character vector.}

\item{method}{Method for combining color histograms. Default is
\code{"mean"}, but other generic functions (\code{"median"}, \code{"sum"},
etc) will work. String is evaluated using \code{"eval"} so any appropriate
R function is accepted.}

\item{...}{Additional arguments passed to \code{\link{getHistList}},
including number of bins, HSV flag, etc.}
}
\description{
Calculates color histograms for images in immediate subdirectories of a
folder, and averages histograms for images in the same subdirectory.
}
\examples{
combined_clusters <- colordistance::combineClusters(system.file("extdata",
"Heliconius", package="colordistance"), method="median", bins=2,
lower=rep(0.8, 3), upper=rep(1, 3))
}
