% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_image_handling.R
\name{plotPixels}
\alias{plotPixels}
\title{Plot pixels in colorspace}
\usage{
plotPixels(img, n = 10000, lower = c(0, 0.55, 0), upper = c(0.24, 1,
  0.24), hsv = FALSE, rev = FALSE)
}
\arguments{
\item{img}{Either a path to an image or a \code{\link{loadImage}} object.}

\item{n}{Number of randomly selected pixels to plot; recommend <20000 for
speed. If n exceeds the number of non-background pixels in the image, all
pixels are plotted. If n is not numeric, all pixels are plotted.}

\item{lower}{RGB or HSV triplet specifying the lower bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]).}

\item{upper}{RGB or HSV triplet specifying the upper bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]). Determining these bounds may
take some trial and error, but the following bounds may work for certain
common background colors: \itemize{ \item Black: lower=c(0, 0, 0);
upper=c(0.1, 0.1, 0.1) \item White: lower=c(0.8, 0.8, 0.8); upper=c(1, 1,
1) \item Green: lower=c(0, 0.55, 0); upper=c(0.24, 1, 0.24) \item Blue:
lower=c(0, 0, 0.55); upper=c(0.24, 0.24, 1) } If no background filtering is
needed, set bounds to some non-numeric value (\code{NULL}, \code{FALSE},
\code{"off"}, etc); any non-numeric value is interpreted as \code{NULL}.}

\item{hsv}{Logical. Should pixels be plotted in HSV instead of RGB
colorspace?}

\item{rev}{Logical. Should the plot be rotated to view pixels which may be
obscured when rev is \code{F}?}
}
\value{
3d plot of pixels in either RGB or HSV colorspace, colored according
  to their color in the image. Uses
  \code{\link[scatterplot3d]{scatterplot3d}} function.
}
\description{
Plots non-background pixels according to their color coordinates, and colors
them according to their RGB or HSV values. Dimensions are either RGB or HSV
depending on flags.
}
\note{
If \code{n} is not numeric, then all pixels are plotted, but this is
  not recommended. Unless the image has a low pixel count, it takes much
  longer, and plotting this many points in the plot window can obscure
  important details.
}
\examples{
colordistance::plotPixels(system.file("extdata",
"Heliconius/Heliconius_B/Heliconius_07.jpeg", package="colordistance"),
n=20000, upper=rep(1, 3), lower=rep(0.8, 3))
}
