% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_scorecard.R
\name{make_scorecard}
\alias{make_scorecard}
\alias{make_bingo}
\title{Create a scorecard for marking progress through domains in an interview}
\usage{
make_scorecard(sme, questions, output_dir)

make_bingo(sme, questions, output_dir = getwd())
}
\arguments{
\item{sme}{Name of SME.}

\item{questions}{Questions object.}

\item{output_dir}{Directory to place scorecards.}
}
\value{
An invisible null.
}
\description{
Creates a two page PDF with one grid for scenarios and one for capabilities.
  Each grid contains a square for each domain. An analyst can mark/stamp
  each domain as it is covered in an interview, gamifying progress.
}
\details{
The domains are ordered according to the SME's expertise profile, ensuring
  they match the interview order flow.
}
\examples{
\dontrun{
questions <- read_questions()
make_scorecard("Sally Expert", questions, output_dir = tempdir())
}
}
