% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{fit_lognorm}
\alias{fit_lognorm}
\title{Find parameters that fit quantile values of an unknown lognormal distribution}
\usage{
fit_lognorm(low, high)
}
\arguments{
\item{low}{5th quantile.}

\item{high}{95th quantile.}
}
\value{
A dataframe.
}
\description{
With a 5th and 95th quantile point estimates, fit a lognormal distribution,
  returning the parameters of the distribution.
}
\examples{
fit_lognorm(low = .20, high = .50)
}
\seealso{
Other distribution fitting functions: \code{\link{combine_lognorm_trunc}},
  \code{\link{combine_lognorm}},
  \code{\link{combine_norm}},
  \code{\link{fit_capabilities_geomean}},
  \code{\link{fit_capabilities}},
  \code{\link{fit_lognorm_trunc}},
  \code{\link{fit_norm_trunc}}, \code{\link{fit_pois}},
  \code{\link{fit_scenarios_geomean}},
  \code{\link{fit_scenarios}},
  \code{\link{fit_threat_communities}},
  \code{\link{generate_cost_function}},
  \code{\link{lognormal_to_normal}},
  \code{\link{normal_to_lognormal}}
}
\concept{distribution fitting functions}
