% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordereddict.R
\docType{data}
\name{OrderedDict}
\alias{OrderedDict}
\title{Ordered Dictionary}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
OrderedDict
}
\description{
The \code{OrderedDict} class creates an ordered dictionary.
Keys are stored in a double ended queue \link{Deque} while items are stored in an R environment.
}
\section{Usage}{

\preformatted{
OrderedDict$new()
OrderedDict$set(key, value)
OrderedDict$get(key, default = NULL)
OrderedDict$remove(key)
OrderedDict$pop(key, default = NULL)
OrderedDict$popitem(last = TRUE, default = NULL)
OrderedDict$has(key)
OrderedDict$keys()
OrderedDict$values()
OrderedDict$update(d)
OrderedDict$size()
OrderedDict$as_list()
}
}

\section{Argument}{

\itemize{
\item \code{key}: any R object, key of the item
\item \code{value}: any R object, value of the item
\item \code{default}: the default value of an item if the key is not found
\item \code{d}: an OrderedDict or OrderedDictL
}
}

\examples{
d <- OrderedDict$new()
d$set("apple", 5)
d$set("orange", 10)
d$set("banana", 3)
d$get("apple")
d$as_list()  # the order the item is preserved
d$pop("orange")
d$as_list()  # "orange" is removed
}
\seealso{
\link{Dict} and \link{OrderedDictL}
}
\keyword{datasets}
