% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapsibleTreeNetwork.R
\name{collapsibleTreeNetwork}
\alias{collapsibleTreeNetwork}
\title{Create Network Interactive Collapsible Tree Diagrams}
\source{
Christopher Gandrud: \url{http://christophergandrud.github.io/networkD3/}.

d3noob: \url{https://bl.ocks.org/d3noob/43a860bc0024792f8803bba8ca0d5ecd}.
}
\usage{
collapsibleTreeNetwork(df, inputId = NULL, attribute = "leafCount",
  aggFun = sum, fill = "lightsteelblue", linkLength = NULL,
  fontSize = 10, tooltip = TRUE, tooltipHtml = NULL, nodeSize = NULL,
  collapsed = TRUE, zoomable = TRUE, width = NULL, height = NULL)
}
\arguments{
\item{df}{a network data frame (where every row is a node)
from which to construct a nested list
\itemize{
 \item First column must be the parent (\code{NA} for root node)
 \item Second column must be the child
 \item Additional columns are passed on as attributes for other parameters
 \item There must be exactly 1 root node
}}

\item{inputId}{the input slot that will be used to access the selected node (for Shiny).
Will return a named list of the most recently clicked node,
along with all of its parents.
(For \code{collapsibleTreeNetwork} the names of the list are tree depth)}

\item{attribute}{numeric column not listed in hierarchy that will be used
as weighting to define the color gradient across nodes. Defaults to 'leafCount',
which colors nodes by the cumulative count of its children}

\item{aggFun}{aggregation function applied to the attribute column to determine
values of parent nodes. Defaults to \code{sum}, but \code{mean} also makes sense.}

\item{fill}{either a single color or a column name with the color for each node}

\item{linkLength}{length of the horizontal links that connect nodes in pixels.
(optional, defaults to automatic sizing)}

\item{fontSize}{font size of the label text in pixels}

\item{tooltip}{tooltip shows the node's label and attribute value.}

\item{tooltipHtml}{column name (possibly containing html) to override
default tooltip contents, allowing for more advanced customization}

\item{nodeSize}{numeric column that will be used to determine relative node size.
Default is to have a constant node size throughout. 'leafCount' can also
be used here (cumulative count of a node's children), or 'count'
(count of node's immediate children).}

\item{collapsed}{the tree's children will start collapsed by default}

\item{zoomable}{pan and zoom by dragging and scrolling}

\item{width}{width in pixels (optional, defaults to automatic sizing)}

\item{height}{height in pixels (optional, defaults to automatic sizing)}
}
\description{
Interactive Reingold-Tilford tree diagram created using D3.js,
where every node can be expanded and collapsed by clicking on it.
This function serves as a convenience wrapper for network style data frames
containing the node's parent in the first column, node parent in the second
column, and additional attributes in the rest of the columns. The root node
is denoted by having an \code{NA} for a parent. There must be exactly 1 root.
}
\examples{
# Create a simple org chart
org <- data.frame(
  Manager = c(
    NA, "Ana", "Ana", "Bill", "Bill", "Bill", "Claudette", "Claudette", "Danny",
    "Fred", "Fred", "Grace", "Larry", "Larry", "Nicholas", "Nicholas"
  ),
  Employee = c(
    "Ana", "Bill", "Larry", "Claudette", "Danny", "Erika", "Fred", "Grace",
    "Henri", "Ida", "Joaquin", "Kate", "Mindy", "Nicholas", "Odette", "Peter"
  ),
  Title = c(
    "President", "VP Operations", "VP Finance", "Director", "Director", "Scientist",
    "Manager", "Manager", "Jr Scientist", "Operator", "Operator", "Associate",
     "Analyst", "Director", "Accountant", "Accountant"
  )
)
collapsibleTreeNetwork(org, attribute = "Title")

# Add in colors and sizes
org$Color <- org$Title
levels(org$Color) <- colorspace::rainbow_hcl(11)
collapsibleTreeNetwork(
  org,
  attribute = "Title",
  fill = "Color",
  nodeSize = "leafCount",
  collapsed = FALSE
)

# Use unsplash api to add in random photos to tooltip
org$tooltip <- paste0(
  org$Employee,
  "<br>Title: ",
  org$Title,
  "<br><img src='https://source.unsplash.com/collection/385548/150x100'>"
)

collapsibleTreeNetwork(
  org,
  attribute = "Title",
  fill = "Color",
  nodeSize = "leafCount",
  tooltipHtml = "tooltip",
  collapsed = FALSE
)

}
\seealso{
\code{\link[data.tree]{FromDataFrameNetwork}} for underlying function
that constructs trees from the network data frame
}
