% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.cointReg}
\alias{print.cointReg}
\title{Print Method for Cointegration Models (Modified OLS).}
\usage{
\method{print}{cointReg}(x, ..., digits = getOption("digits"),
  all.coeffs = FALSE)
}
\arguments{
\item{x}{[\code{cointReg}]\cr
Object of class \code{"cointReg"}, i.e. the result of
\code{cointRegFM}, \code{cointRegD} or \code{cointRegIM}.}

\item{...}{ignored}

\item{digits}{[\code{numeric}]\cr
Number of significant digits to be used.}

\item{all.coeffs}{[\code{logical}]\cr
Whether to show all coefficients (i. e. the "real" regressors AND the
auxiliary regressors). Default is \code{FALSE}.}
}
\value{
The invisible \code{x} object.
}
\description{
Printing objects of class \code{"cointReg"}.
}
\examples{
set.seed(42)
x = data.frame(x1 = cumsum(rnorm(200)), x2 = cumsum(rnorm(200)))
eps1 = rnorm(200, sd = 2)
y = x$x1 - x$x2 + 10 + eps1
deter = cbind(level = rep(1, 200))

test.fm = cointRegFM(x = x, y = y, deter = deter)
print(test.fm)

test.d = cointRegD(x = x, y = y, deter = deter)
print(test.d)

test.im2 = cointRegIM(x = x, y = y, deter = deter)
print(test.im2)

}
\seealso{
Other cointReg: \code{\link{cointRegD}},
  \code{\link{cointRegFM}}, \code{\link{cointRegIM}},
  \code{\link{cointReg}}, \code{\link{plot.cointReg}}
}

