% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step}
\alias{step}
\title{Create filtering step}
\usage{
step(...)
}
\arguments{
\item{...}{Filters. See \link{filter}.}
}
\value{
List of class `cb_step` storing filters configuration.
}
\description{
Steps all to perform multiple stages of Source data filtering.
}
\examples{
library(magrittr)
iris_step_1 <- step(
  filter('discrete', dataset = 'iris', variable = 'Species', value = 'setosa'),
  filter('discrete', dataset = 'iris', variable = 'Petal.Length', range = c(1.5, 2))
)
iris_step_2 <- step(
  filter('discrete', dataset = 'iris', variable = 'Sepal.Length', range = c(5, 10))
)

# Add step directly to Cohort
iris_source <- set_source(tblist(iris = iris))
coh <- iris_source \%>\%
  cohort(
    iris_step_1,
    iris_step_2
  ) \%>\%
  run()

nrow(get_data(coh, step_id = 1)$iris)
nrow(get_data(coh, step_id = 2)$iris)

# Add step to Cohort using add_step method
coh <- iris_source \%>\%
  cohort()
coh <- coh \%>\%
  add_step(iris_step_1) \%>\%
  add_step(iris_step_2) \%>\%
  run()

}
