% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dcoga2dim}
\alias{dcoga2dim}
\alias{pcoga2dim}
\title{Convolution of Two Gamma Distributions.}
\usage{
dcoga2dim(x, shape1, shape2, rate1, rate2)

pcoga2dim(x, shape1, shape2, rate1, rate2)
}
\arguments{
\item{x}{Quantiles.}

\item{shape1, shape2}{Shape parameters of the first and second gamma
distributions, all shape parameters >= 0, at least one shape parameter > 0.}

\item{rate1, rate2}{Rate parameters of the first and second gamma
distributions, all rate parameters > 0.}
}
\description{
Density, and distribution function of convolution of two gamma
distributions is a special situation of convolution of gamma
distributions. Compare to the general situation, the speed of code
is much faster. The algorithm of these two functions comes from
Mathai, A.M. (1982).
}
\examples{
## do grid
y <- rcoga(100000, c(3,4), c(2,3))
grid <- seq(0, 15, length.out=100)
## calculate pdf and cdf
pdf <- dcoga2dim(grid, 3, 4, 2, 3)
cdf <- pcoga2dim(grid, 3, 4, 2, 3)

## plot pdf
plot(density(y), col="blue")
lines(grid, pdf, col="red")

## plot cdf
plot(ecdf(y), col="blue")
lines(grid, cdf, col="red")

}
\references{
Mathai, A.M.: Storage capacity of a dam with gamma type inputs.
Ann. Inst. Statist.Math. 34, 591-597 (1982)
}
\author{
Chaoran Hu
}
