% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/synchrony.R
\name{synch_onerep}
\alias{synch_onerep}
\title{A function to calculate species synchrony over time within one replicate}
\usage{
synch_onerep(df, time.var, species.var, abundance.var, metric = c("Loreau",
  "Gross"))
}
\arguments{
\item{df}{A dataframe containing rep, time, species and abundance columns}

\item{time.var}{The name of the time column from df}

\item{species.var}{The name of the species column from df}

\item{abundance.var}{The name of the abundance column from df}

\item{metric}{The synchrony metric to return. The default, "Loreau", returns synchrony as calculated by Loreau and de Mazancourt 2008.
The alternative, "Gross", returns synchrony as calculated by Gross et al. 2014}
}
\value{
output The degree of species synchrony. If "Loreau", 1 is perfect synchrony and 0 is perfect asynchrony.
       If "Gross", 1 is perfect synchrony and -1 is perfect asynchrony.
}
\description{
A function to calculate species synchrony over time within one replicate
}

