% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{get.cocor.results}
\alias{get.cocor.results}
\alias{get.cocor.results,-method}
\alias{get.cocor.results,cocor-method}
\alias{get.cocor.results,cocor.dep.groups.nonoverlap-method}
\alias{get.cocor.results,cocor.dep.groups.overlap-method}
\alias{get.cocor.results,cocor.indep.groups-method}
\title{Get result parameters of a cocor result object}
\usage{
get.cocor.results(result.object, test = "all")

\S4method{get.cocor.results}{cocor}(result.object, test = "all")
}
\arguments{
\item{result.object}{A cocor result object of class 'cocor.indep.groups',
      'cocor.dep.groups.overlap', or 'cocor.dep.groups.nonoverlap'.}

\item{test}{A vector of character strings specifying the tests to be returned (e.g.,
      \code{pearson1898},
      \code{dunn1969}...). Use \code{all} to return the results of all tests (default).}
}
\value{
Returns a list containing all result parameters as list elements:
\item{diff}{Difference between the two correlations that were compared.}
\item{statistic}{The value of the test statistic (unless test zou2007 is used).}
\item{distribution}{The distribution of the test statistic (unless test zou2007 is used).}
\item{df}{The degrees of freedom of the distribution of the test statistic (only for result objects of class 'cocor.dep.groups.overlap' if test hotelling1940,
      hendrickson1970, or williams1959 is used).}
\item{p.value}{The p-value of the test (unless test zou2007 is used).}
\item{conf.int}{The confidence interval of the difference between the two correlations (if test zou2007 is used).}
}
\description{
Returns result parameters of a cocor result object of class 'cocor.indep.groups',
      'cocor.dep.groups.overlap',
      or 'cocor.dep.groups.nonoverlap' as a list with each slot representing a list element.
}
\examples{
data("aptitude")

cocor.result <- cocor(~knowledge + intelligence.a | logic + intelligence.a,
      aptitude$sample1)
get.cocor.results(cocor.result)
}
\seealso{
\link{get.cocor.input}, \link{cocor}, \link{cocor.indep.groups},
      \link{cocor.dep.groups.overlap}, \link{cocor.dep.groups.nonoverlap}
}

