% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.tab.time.list.R
\name{bal.tab.time.list}
\alias{bal.tab.time.list}
\alias{bal.tab.formula.list}
\alias{bal.tab.data.frame.list}
\title{Balance Statistics for Longitudinal Datasets}
\usage{
\method{bal.tab}{formula.list}(
  x,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  data = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  ...
)

\method{bal.tab}{data.frame.list}(
  x,
  treat.list,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  data = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  ...
)
}
\arguments{
\item{x}{either a list of data frames containing all the covariates to be assessed at each time point or a list of formulas with the treatment for each time period on the left and the covariates for which balance is to be displayed on the right. Covariates to be assessed at multiple points must be included in the entries for each time point. Data must be in the "wide" format, with one row per unit. If a formula list is supplied, an argument to \code{data} is required unless all objects in the formulas exist in the environment.}

\item{stats}{\code{character}; which statistic(s) should be reported. See \code{\link[=balance-statistics]{stats}} for allowable options. For binary and multi-category treatments, \code{"mean.diffs"} (i.e., mean differences) is the default. For continuous treatments, \code{"correlations"} (i.e., treatment-covariate Pearson correlations) is the default. Multiple options are allowed.}

\item{int}{\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well.}

\item{poly}{\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.}

\item{distance}{an optional formula or data frame containing distance values (e.g., propensity scores) or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the argument to \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{addl}{an optional formula or data frame containing additional covariates for which to present balance or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the arguments to the input object, \code{covs}, and \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{data}{an optional data frame containing variables named in other arguments. For some input object types, this is required.}

\item{continuous}{whether mean differences for continuous variables should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"std"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{binary}{whether mean differences for binary variables (i.e., difference in proportion) should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"raw"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{s.d.denom}{\code{character}; how the denominator for standardized mean differences should be calculated, if requested. See \code{\link[=col_w_smd]{col_w_smd()}} for allowable options. Abbreviations allowed. It is recommended not to set this argument for longitudinal treatments.}

\item{thresholds}{a named vector of balance thresholds, where the name corresponds to the statistic (i.e., in \code{stats}) that the threshold applies to. For example, to request thresholds on mean differences and variance ratios, one can set \code{thresholds = c(m = .05, v = 2)}. Requesting a threshold automatically requests the display of that statistic. When specified, extra columns are inserted into the Balance table describing whether the requested balance statistics exceeded the threshold or not. Summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure are added to the output.}

\item{weights}{a vector, list, or \code{data.frame} containing weights for each unit, or a string containing the names of the weights variables in \code{data}, or an object with a \code{\link[=get.w]{get.w()}} method or a list thereof. The weights can be, e.g., inverse probability weights or matching weights resulting from a matching algorithm.}

\item{cluster}{either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the input object. See \code{\link{class-bal.tab.cluster}} for details.}

\item{imp}{either a vector containing imputation indices for each unit or a string containing the name of the imputation index variable in \code{data} or the input object. See \code{\link{class-bal.tab.imp}} for details. Not necessary if \code{data} is a \code{mids} object.}

\item{pairwise}{whether balance should be computed for pairs of treatments or for each treatment against all groups combined. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details. This can also be used with a binary treatment to assess balance with respect to the full sample.}

\item{s.weights}{Optional; either a vector containing sampling weights for each unit or a string containing the name of the sampling weight variable in \code{data}. These function like regular weights except that both the adjusted and unadjusted samples will be weighted according to these weights if weights are used.}

\item{abs}{\code{logical}; whether displayed balance statistics should be in absolute value or not.}

\item{subset}{a \code{logical} or \code{numeric} vector denoting whether each observation should be included or which observations should be included. If \code{logical}, it should have length equal to the number of units. \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.}

\item{quick}{\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.}

\item{...}{for some input types, other arguments that are required or allowed. Otherwise, further arguments to control display of output. See \link[=display-options]{display options} for details.}

\item{treat.list}{treatment status for each unit at each time point. This can be specified as a list or data frame of vectors, each of which contains the treatment status of each individual at each time point, or a list or vector of the names of variables in \code{data} that contain treatment at each time point. Required for the \code{data.frame.list} method.}
}
\value{
An object of class \code{bal.tab.msm} containing balance summaries at each time point. Each balance summary is its own \code{bal.tab} object. See \code{\link{class-bal.tab.msm}} for more details.

See \code{\link[=bal.tab.formula]{bal.tab() base methods()}} for more detailed information on the value of the \code{bal.tab} objects produced for each time point.
}
\description{
Generates balance statistics for data coming from a longitudinal treatment scenario. The primary input is in the form of a list of formulas or \code{data.frame}s contain the covariates at each time point. \code{bal.tab()} automatically classifies this list as either a \code{data.frame.list} or \code{formula.list}, respectively.
}
\details{
\code{bal.tab.formula.list()} and \code{bal.tab.data.frame.list()} generate a list of balance summaries for each time point based on the treatments and covariates provided. All data must be in the "wide" format, with exactly one row per unit and columns representing variables at different time points. See the \pkgfun{WeightIt}{weightitMSM} documentation for an example of how to transform long data into wide data using \code{\link[=reshape]{reshape()}}.

Multiple sets of weights can be supplied simultaneously by including entering a data frame or a character vector containing the names of weight variables found in \code{data} or a list thereof. When only one set of weights is supplied, the output for the adjusted group will simply be called \code{"Adj"}, but otherwise will be named after each corresponding set of weights. Specifying multiple sets of weights will also add components to other outputs of \code{bal.tab()}.
}
\examples{
\dontshow{if (requireNamespace("twang", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("iptwExWide", package = "twang")
library("cobalt")

## Estimating longitudinal propensity scores and weights
ps1 <- glm(tx1 ~ age + gender + use0,
           data = iptwExWide, 
           family = "binomial")$fitted.values
w1 <- ifelse(iptwExWide$tx1 == 1, 1/ps1, 1/(1-ps1))
ps2 <- glm(tx2 ~ age + gender + use0 + tx1 + use1,
           data = iptwExWide, 
           family = "binomial")$fitted.values
w2 <- ifelse(iptwExWide$tx2 == 1, 1/ps2, 1/(1-ps2))
ps3 <- glm(tx3 ~ age + gender + use0 + tx1 + use1 + tx2 + use2,
           data = iptwExWide, 
           family = "binomial")$fitted.values
w3 <- ifelse(iptwExWide$tx3 == 1, 1/ps3, 1/(1-ps3))

w <- w1*w2*w3

# Formula interface plus addl:
bal.tab(list(tx1 ~ use0 + gender,
             tx2 ~ use0 + gender + use1 + tx1,
             tx3 ~ use0 + gender + use1 + tx1 + use2 + tx2),
        data = iptwExWide, 
        weights = w,
        distance = list(~ps1, ~ps2, ~ps3),
        addl = ~age*gender,
        un = TRUE)

# data frame interface:
bal.tab(list(iptwExWide[c("use0", "gender")],
             iptwExWide[c("use0", "gender", "use1", "tx1")],
             iptwExWide[c("use0", "gender", "use1", "tx1", "use2", "tx2")]),
        treat.list = iptwExWide[c("tx1", "tx2", "tx3")], 
        weights = w,
        distance = list(~ps1, ~ps2, ~ps3),
        un = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=bal.tab]{bal.tab()}} for details of calculations.
\item \code{\link{class-bal.tab.msm}} for output and related options.
\item \code{\link{class-bal.tab.cluster}} for more information on clustered data.
\item \code{\link{class-bal.tab.imp}} for more information on multiply imputed data.
\item \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for more information on multi-category treatments.
}
}
