\name{bal.tab.mimids}
\alias{bal.tab.mimids}
\alias{bal.tab.wimids}
\title{
Balance Statistics for \code{MatchThem} Objects
}
\description{
Generates balance statistics for \code{mimids} and \code{wimids} objects from \pkg{MatchThem}.
}
\usage{
\method{bal.tab}{mimids}(x, 
        stats,
        int = FALSE,
        poly = 1,
        distance = NULL,
        addl = NULL,
        data = NULL,
        continuous,
        binary,
        s.d.denom,
        thresholds = NULL,
        weights = NULL,
        cluster = NULL,
        pairwise = TRUE,
        s.weights = NULL,
        abs = FALSE,
        subset = NULL,
        quick = TRUE,
        ...)
}

\arguments{
  \item{x}{
a \code{mimids} or \code{wimids} object; the output of a call to \pkgfun{MatchThem}{matchthem} or \pkgfun{MatchThem}{weightthem}.
}
  \item{stats, int, poly, addl, data, continuous, binary, thresholds, weights, cluster, pairwise, s.weights, abs, subset, quick, \dots}{
see \fun{bal.tab} for details.

See below for special notes on the \code{distance}, \code{s.d.denom}, and \code{imp} arguments. Note the \code{imp} argument is ignored because the imputation identifers are already present in the input object.
}
The following arguments have special notes when used with \code{mimids} and \code{wimids} objects:
  \item{distance}{
the distance measure generated by \code{matchthem()} or \code{weightthem()} is automatically included and named "distance" or "prop.score", respectively.
}
  \item{s.d.denom}{
the defaults depend on the options specified in the original function calls; see \fun{bal.tab.matchit} and \fun{bal.tab.weightit} for details on the defaults.
}
}
\details{
\code{bal.tab.mimids()} and \code{bal.tab.wimids()} generate a list of balance summaries for the \code{mimids} or \code{wimids} object given.
}
\value{
If clusters are not specified, an object of class \code{"bal.tab.imp"} containing balance summaries for each imputation and a summary of balance across imputations. See \code{\link[=class-bal.tab.imp]{bal.tab.imp}} for details.

If clusters are specified, an object of class \code{"bal.tab.imp.cluster"} containing summaries between and across all clusters and imputations.
}

\author{
Noah Greifer 
}

\seealso{
\fun{bal.tab} for details of calculations.

\fun{bal.tab.matchit} and \fun{bal.tab.weightit}
}
\examples{\dontshow{if (all(sapply(c("mice", "MatchThem", "MatchIt", "WeightIt"), requireNamespace, quietly = TRUE))) force(\{ # examplesIf}
library(mice)
library(MatchThem)

data("lalonde_mis", package = "cobalt")

#Imputing the missing data
imp <- mice(lalonde_mis, m = 5)

#Matching using within-imputation propensity scores
mt.out1 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within")
bal.tab(mt.out1)

#Matching using across-imputation average propensity scores
mt.out2 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "across")
                       
bal.tab(mt.out2)

#Weighting using within-imputation propensity scores
wt.out <- weightthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within",
                       estimand = "ATT")
                       
bal.tab(wt.out)
\dontshow{\}) # examplesIf}}
\keyword{tables}
