% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_four_gamete.R
\name{sumstat_four_gamete}
\alias{sumstat_four_gamete}
\title{Summary Statistic: Four-Gamete-Condition}
\usage{
sumstat_four_gamete(name = "four_gamete", population = 1,
  transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.
Can also be "all" to calculate it from all populations.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
The statistic generates a matrix where each row represents one locus, and
  the columns give the statistic for different classes of pairs of SNPs:

  \describe{
   \item{mid_near}{The value for all pairs of SNPs that are close together,
    that is within 10 percent of the locus" length. If locus trios are used,
    only pairs of SNPs were both SNPs are on the middle locus are considered.
    }
   \item{mid_far}{Same as \code{mid_near}, but for pairs of SNPs that are
    more that 10 percent of the locus" length apart. }
   \item{outer}{Only when using locus trios. The statistic for pairs
    where both SNPs are on the same outer locus.}
   \item{between}{Only when using locus trios. The statistic for pairs
    where one SNPs is on the middle locus, and the other is on an outer one.}
   \item{mid}{The value for all pairs on the
    middle locus or all pairs when not using trios.}
   \item{perc_polym}{The percentage of positions that are polymorpic.}
  }
}
\description{
This summary statistic calculates a number of values (see 'Value')
related to the Four-Gamete-Condition (see 'Details').
It is sensitive for recombination and particularly useful when estimating
recombination rates with \pkg{jaatha} or Approximate Bayesian Computation.
}
\details{
The Four-Gamete-Condition for two SNPs is violated if all four combinations
of derived and ancestral alleles at the SNPs are observed in a gamete/a
haplotype. Under an Infinite-Sites mutation model, a violation indicates that
there must have been at least one recombination event between the SNPs.
}
\section{Unphased Data}{

For unphased data, the four gamete condition is only counted as violated if
it is violated for all possible phasing of the data.
}

\examples{
model <- coal_model(5, 2) +
 feat_mutation(50) +
 feat_recombination(10) +
 sumstat_four_gamete()
stats <- simulate(model)
print(stats$four_gamete)
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_dna}},
  \code{\link{sumstat_file}}, \code{\link{sumstat_ihh}},
  \code{\link{sumstat_jsfs}}, \code{\link{sumstat_mcmf}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_sfs}},
  \code{\link{sumstat_tajimas_d}},
  \code{\link{sumstat_trees}}
}
