# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

parse_ms_positions <- function(line) {
    .Call('coala_parse_ms_positions', PACKAGE = 'coala', line)
}

parse_ms_output <- function(file_names, sample_size, loci_number) {
    .Call('coala_parse_ms_output', PACKAGE = 'coala', file_names, sample_size, loci_number)
}

parse_sg_output <- function(file_names, sample_size, sequence_length, loci_number, outgroup_size = 1L, calc_seg_sites = TRUE) {
    .Call('coala_parse_sg_output', PACKAGE = 'coala', file_names, sample_size, sequence_length, loci_number, outgroup_size, calc_seg_sites)
}

generate_trio_trees <- function(trees, llm) {
    .Call('coala_generate_trio_trees', PACKAGE = 'coala', trees, llm)
}

calc_four_gamete_stat <- function(seg_sites_list, individuals, locus_length) {
    .Call('coala_calc_four_gamete_stat', PACKAGE = 'coala', seg_sites_list, individuals, locus_length)
}

#' Calculates the JSFS for two populations
#'
#' @param seg_sites List of segregating sites
#' @param pop1 The rows of \code{seg_sites} that correspond to individuals
#'   of the first population.
#' @param pop2 same as \code{pop1}, but for the second population.
#' @export
#' @return The Joint Site Frequency Spectrum, as a matrix.
calc_jsfs <- function(seg_sites, pop1, pop2) {
    .Call('coala_calc_jsfs', PACKAGE = 'coala', seg_sites, pop1, pop2)
}

calc_nucleotide_div <- function(seg_sites, individuals) {
    .Call('coala_calc_nucleotide_div', PACKAGE = 'coala', seg_sites, individuals)
}

calc_omegaprime <- function(seg_sites, individuals) {
    .Call('coala_calc_omegaprime', PACKAGE = 'coala', seg_sites, individuals)
}

unphase_segsites <- function(seg_sites, ploidy, samples_per_ind) {
    .Call('coala_unphase_segsites', PACKAGE = 'coala', seg_sites, ploidy, samples_per_ind)
}

