% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnr.R
\name{augment.mnr}
\alias{augment.mnr}
\title{Augment data with information from an \code{mnr} object}
\usage{
\method{augment}{mnr}(x, data = x$data, ...)
}
\arguments{
\item{x}{an \code{mnr} object created by
\code{\link{maximum_normed_residual}}}

\item{data}{a \code{data.frame} or
\code{\link[tibble:tibble]{tibble::tibble}}
containing the original data that was passed to
\code{maximum_normed_residual}}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
When \code{data} is supplied, \code{augment} returns \code{data}, but with
one column appended. When \code{data} is not supplied, \code{augment}
returns a new \code{\link[tibble:tibble]{tibble::tibble}} with the column
\code{values} containing the original values used by
\code{maximum_normed_residaul} plus one additional column. The additional
column is:

\item{\code{.outler}}{a logical value indicating whether the observation
                      is an outlier}
}
\description{
Augment accepts an \code{mnr} object (returned from the function
\code{\link{maximum_normed_residual}}) and a dataset and adds the column
\code{.outlier} to the dataset. The column \code{.outlier} is a logical
vector indicating whether each observation is an outlier.

When passing data into \code{augment} using the \code{data} argument,
the data must be exactly the data that was passed to
\code{maximum_normed_residual}.
}
\examples{
data <- data.frame(strength = c(80, 98, 96, 97, 98, 120))
m <- maximum_normed_residual(data, strength)

# augment can be called with the original data
augment(m, data)

##   strength .outlier
## 1       80    FALSE
## 2       98    FALSE
## 3       96    FALSE
## 4       97    FALSE
## 5       98    FALSE
## 6      120    FALSE

# or augment can be called without the orignal data and it will be
# reconstructed
augment(m)

## # A tibble: 6 x 2
##   values .outlier
##    <dbl> <lgl>
## 1     80 FALSE
## 2     98 FALSE
## 3     96 FALSE
## 4     97 FALSE
## 5     98 FALSE
## 6    120 FALSE

}
\seealso{
\code{\link{maximum_normed_residual}}
}
