% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{CIF_Figs}
\alias{CIF_Figs}
\title{Plot Cumulative Incidence Functions (CIF) with Confidence Intervals}
\usage{
CIF_Figs(initial_params, TimeFailure, OrderType = c(2, 1), RiskNames = NULL)
}
\arguments{
\item{initial_params}{A numeric vector of initial parameter values to start the optimization.}

\item{TimeFailure}{A numeric vector of failure times corresponding to observations.}

\item{OrderType}{A numeric vector indicating the order of the competing risks. Default is \code{c(2, 1)}.}

\item{RiskNames}{A character vector of names for the competing risks. Default is \code{NULL}.}
}
\value{
A ggplot object showing the CIFs and their confidence intervals.
}
\description{
This function plots the cumulative incidence functions (CIF) for two competing risks based on the estimated parameters and their variances. It includes confidence intervals for the CIFs.
}
\details{
This function performs the following steps:
\itemize{
\item Estimates the model parameters using the \code{estimate_parameters} function.
\item Computes the Hessian matrix using the \code{compute_hessian} function.
\item Ensures that the diagonal elements of the covariance matrix are positive.
\item Computes the cumulative incidence functions (CIF) for two competing risks.
\item Plots the CIFs along with their confidence intervals.
}
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
initial_params <- c(0.001, 0.001, 0.001, 0.001)
result <- CIF_res1(initial_params)
print(result)
initial_params <- c(0.01, 0.01, 0.01, 0.01)
TimeFailure <- seq(0, 10, by = 0.1)
plot <- CIF_Figs(initial_params, TimeFailure)
print(plot)

}
