% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bilinear.R
\name{bilinear}
\alias{bilinear}
\title{Bilinear interpolation}
\usage{
bilinear(x, y, z, newx, newy)
}
\arguments{
\item{x}{vector of two x values representing \code{x_1} and \code{x_2}}

\item{y}{vector of two y values representing \code{y_1} and \code{y_2}}

\item{z}{2x2 matrix if \code{z} values}

\item{newx}{vector of new \code{x} values to interpolate}

\item{newy}{vector of new \code{y} values to interpolate}
}
\value{
a vector of interpolated z values at (\code{x}, \code{y})
}
\description{
Finds a bilinear interpolation bounded by four points
}
\details{
\code{bilinear} finds a bilinear interpolation bounded by four corners
}
\examples{
x <- c(2, 4)
y <- c(4, 7)
z <- matrix(c(81, 84, 85, 89), nrow = 2)
newx <- c(2.5, 3, 3.5)
newy <- c(5, 5.5, 6)
bilinear(x, y, z, newx, newy)

}
\seealso{
Other interp: 
\code{\link{bezier}},
\code{\link{cubicspline}()},
\code{\link{linterp}()},
\code{\link{nn}()},
\code{\link{polyinterp}()},
\code{\link{pwiselinterp}()}

Other algebra: 
\code{\link{cubicspline}()},
\code{\link{division}},
\code{\link{fibonacci}()},
\code{\link{horner}()},
\code{\link{isPrime}()},
\code{\link{linterp}()},
\code{\link{nthroot}()},
\code{\link{polyinterp}()},
\code{\link{pwiselinterp}()},
\code{\link{quadratic}()}
}
\concept{algebra}
\concept{interp}
