% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivesum.R
\name{summation}
\alias{summation}
\alias{naivesum}
\alias{kahansum}
\alias{pwisesum}
\title{Two summing algorithms}
\usage{
naivesum(x)

kahansum(x)

pwisesum(x)
}
\arguments{
\item{x}{a vector of numbers to be summed}
}
\value{
the sum
}
\description{
Find the sum of a vector
}
\details{
\code{naivesum} calculates the sum of a vector by keeping a counter
and repeatedly adding the next value to the interim sum.
\code{kahansum} uses Kahan's algorithm to capture the low-order
precision loss and ensure that the loss is reintegrated into the
final sum.  \code{pwisesum} is a recursive implementation of the
piecewise summation algorithm that divides the vector in two and adds
the individual vector sums for a result.
}
\examples{
k <- 1:10^6
n <- sample(k, 1)
bound <- sample(k, 2)
bound.upper <- max(bound) - 10^6 / 2
bound.lower <- min(bound) - 10^6 / 2
x <- runif(n, bound.lower, bound.upper)
naivesum(x)
kahansum(x)
pwisesum(x)
}
\concept{intro}
