% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items.R
\name{item_factors}
\alias{item_factors}
\title{Determine latent factors for a new item}
\usage{
item_factors(
  model,
  X = NULL,
  X_col = NULL,
  X_val = NULL,
  I = NULL,
  I_col = NULL,
  I_val = NULL,
  I_bin = NULL,
  weight = NULL,
  output_bias = FALSE
)
}
\arguments{
\item{model}{A collective matrix factorization model from this package - see
\link{fit_models} for details.}

\item{X}{New `X` data, either as a numeric vector (class `numeric`), or as
a sparse vector from package `Matrix` (class `dsparseVector`). If the `X` to
which the model was fit was a `data.frame`, the user/row indices will have
been reindexed internally, and the numeration can be found under
`model$info$user_mapping`. Alternatively, can instead pass the column indices
and values and let the model reindex them (see `X_col` and `X_val`).
Should pass at most one of `X` or `X_col`+`X_val`.

Be aware that, unlikely in pretty much every other function in this package,
here the values are for one \bold{column} of `X`, not one \bold{row} like
in e.g. \link{factors_single}.

Dense `X` data is not supported for `CMF_implicit` or `OMF_implicit`.

Not supported for the `ContentBased` model.}

\item{X_col}{New `X` data in sparse vector format, with `X_col` denoting the
users/rows which are not missing. If the `X` to which the model was fit was
a `data.frame`, here should pass IDs matching to the first column of that `X`,
which will be reindexed internally. Otherwise, should have \bold{row} indices with
numeration starting at 1 (passed as an integer vector).
Should pass at most one of `X` or `X_col`+`X_val`.

Not supported for the `ContentBased` model.}

\item{X_val}{New `X` data in sparse vector format, with `X_val` denoting the
associated values to each entry in `X_col`
(should be a numeric vector of the same length as `X_col`).
Should pass at most one of `X` or `X_col`+`X_val`.

Not supported for the `ContentBased` model.}

\item{I}{New `I` data, either as a numeric vector (class `numeric`), or as a
sparse vector from package `Matrix` (class `dsparseVector`). Alternatively,
if `I` is sparse, can instead pass the indices of the non-missing columns
and their values separately (see `I_col`).
Should pass at most one of `I` or `I_col`+`I_val`.}

\item{I_col}{New `I` data in sparse vector format, with `I_col` denoting the
attributes/columns which are not missing. Should have numeration starting at 1
(should be an integer vector).
Should pass at most one of `I` or `I_col`+`I_val`.}

\item{I_val}{New `I` data in sparse vector format, with `I_val` denoting the
associated values to each entry in `I_col`
(should be a numeric vector of the same length as `I_col`).
Should pass at most one of `I` or `I_col`+`I_val`.}

\item{I_bin}{Binary columns of `I` on which a sigmoid transformation will be
applied. Should be passed as a numeric vector. Note that `I` and `I_bin` are
not mutually exclusive.}

\item{weight}{(Only for the explicit-feedback models)
Associated weight to each non-missing observation in `X`. Must have the same
number of entries as `X` - that is, if passing a dense vector of length `m`,
`weight` should be a numeric vector of length `m` too, if passing a sparse
vector, should have a length corresponding to the number of non-missing elements.}

\item{output_bias}{Whether to also return the item bias determined by the model
given the data in `X` (for explicit-feedback models fit with item biases).}
}
\value{
If passing `output_bias=FALSE`, will return a vector with
the obtained latent factors for this item. If passing `output_bias=TRUE`, the
result will be a list with entry `factors` having the above vector, and entry
`bias` having the estimated bias.
}
\description{
Calculate latent factors for a new item, based on either
new `X` data, new `I` data, or both.

Be aware that the package is user/row centric, and this function is provided for
quick experimentation purposes only. Calculating item factors will be slower
than calculating user factors
(except for the `ContentBased` model for which both types of predictions
are equally fast and equally supported).
as it will not make usage of the precomputed
matrices. If item-based  predictions are required, it's recommended to use
instead the function \link{swap.users.and.items} and then use the resulting
object with \link{factors_single} or \link{factors}.
}
\seealso{
\link{factors_single} \link{predict_new_items}
}
