% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{ceuclide}
\alias{ceuclide}
\title{Calculate the Euclidean distance of a factor in a dataframe.}
\usage{
ceuclide(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Euclidean Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{The factor which you want to calculate the Euclidean distances matrix.}

\item{plot}{If TRUE, shows a plot of the Euclidean distances matrix.}

\item{plot_title}{The title of the plot.}
}
\value{
The matrix containing distances.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Euclidean distances about it.
}
\details{
Calculate Euclidean distance
}
\examples{

# Example with iris dataset

ceuclide(iris, ~Species, plot = TRUE, plot_title = "Euclidean Distance Between Groups")

# Example with mtcars dataset

ceuclide(mtcars, ~am, plot = TRUE, plot_title = "Euclidean Distance Between Groups")

}
