% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{check_df}
\alias{check_df}
\title{Checks if non-empty groups have enough data for spline fit
degrees of freedom.}
\usage{
check_df(group, loss, data, maxdf)
}
\arguments{
\item{group}{An integer vector of group membership for each id.}

\item{loss}{A matrix with rows of computed loss values of each id across all models
as columns.}

\item{data}{A data.table with data. See \code{\link{trajectories}}.}

\item{maxdf}{Fitting parameters. See \code{\link{trajectories}}.}
}
\value{
Returns the vector of group membership of id's either unchanged or changed
to have sufficient data in non-zero groups.
}
\description{
Checks if non-empty groups have enough data for spline fit
degrees of freedom.
}
\details{
When a group has insufficient data for \code{maxdf}, its nearest model loss
values are set to \code{Inf}, and new nearest model is assigned. The check
repeats until all groups have sufficient data.
}
