% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_functions.R
\name{boot_alg_list}
\alias{boot_alg_list}
\title{Performs nonparametric bootstrap to a graph and a list of clustering algorithms}
\usage{
boot_alg_list(
  alg_list = list(Louvain = cluster_louvain, `label prop` = cluster_label_prop, walktrap
    = cluster_walktrap),
  g,
  R = 999,
  return_data = FALSE,
  type = "global"
)
}
\arguments{
\item{alg_list}{List of igraph clustering algorithms}

\item{g}{\code{igraph} graph object}

\item{R}{Number of bootstrap replicates.}

\item{return_data}{Logical. If \code{TRUE}, returns a list of "\code{boot}" objects
with the full results. Otherwise, returns a table with the mean results.}

\item{type}{Can be "global" (Variation of Information, Reduced Mutual Information, 
and adjusted Rand Index) or "cluster-wise" (Jaccard distance)}
}
\value{
If \code{return_data} is set to \code{TRUE}, returns a list of objects of
class "\code{boot}" (see \code{\link[boot]{boot}}). Otherwise, returns as table 
with the mean distances from the clusters in the original graph to the resampled
ones, for each of the algorithms.
}
\description{
Performs nonparametric bootstrap on a graph's by resampling its vertices and
clustering the results using a list of clustering algorithms.
}
