/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.services.rds.model.DBParameterGroupStatus;
import com.amazonaws.services.rds.model.DBSecurityGroupMembership;
import com.amazonaws.services.rds.model.Endpoint;
import com.amazonaws.services.rds.model.PendingModifiedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInstance {
    private String dBInstanceIdentifier;
    private String dBInstanceClass;
    private String engine;
    private String dBInstanceStatus;
    private String masterUsername;
    private String dBName;
    private Endpoint endpoint;
    private Integer allocatedStorage;
    private Date instanceCreateTime;
    private String preferredBackupWindow;
    private Integer backupRetentionPeriod;
    private List<DBSecurityGroupMembership> dBSecurityGroups;
    private List<DBParameterGroupStatus> dBParameterGroups;
    private String availabilityZone;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private Date latestRestorableTime;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String readReplicaSourceDBInstanceIdentifier;
    private List<String> readReplicaDBInstanceIdentifiers;
    private String licenseModel;

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public DBInstance withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public DBInstance withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public DBInstance withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getDBInstanceStatus() {
        return this.dBInstanceStatus;
    }

    public void setDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
    }

    public DBInstance withDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public DBInstance withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public DBInstance withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public DBInstance withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public DBInstance withAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
        return this;
    }

    public Date getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public void setInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public DBInstance withInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
        return this;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public DBInstance withPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public DBInstance withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
        return this;
    }

    public List<DBSecurityGroupMembership> getDBSecurityGroups() {
        if (this.dBSecurityGroups == null) {
            this.dBSecurityGroups = new ArrayList<DBSecurityGroupMembership>();
        }
        return this.dBSecurityGroups;
    }

    public void setDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
            return;
        }
        ArrayList<DBSecurityGroupMembership> dBSecurityGroupsCopy = new ArrayList<DBSecurityGroupMembership>(dBSecurityGroups.size());
        dBSecurityGroupsCopy.addAll(dBSecurityGroups);
        this.dBSecurityGroups = dBSecurityGroupsCopy;
    }

    public DBInstance withDBSecurityGroups(DBSecurityGroupMembership ... dBSecurityGroups) {
        if (this.getDBSecurityGroups() == null) {
            this.setDBSecurityGroups(new ArrayList<DBSecurityGroupMembership>(dBSecurityGroups.length));
        }
        for (DBSecurityGroupMembership value : dBSecurityGroups) {
            this.getDBSecurityGroups().add(value);
        }
        return this;
    }

    public DBInstance withDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
        } else {
            ArrayList<DBSecurityGroupMembership> dBSecurityGroupsCopy = new ArrayList<DBSecurityGroupMembership>(dBSecurityGroups.size());
            dBSecurityGroupsCopy.addAll(dBSecurityGroups);
            this.dBSecurityGroups = dBSecurityGroupsCopy;
        }
        return this;
    }

    public List<DBParameterGroupStatus> getDBParameterGroups() {
        if (this.dBParameterGroups == null) {
            this.dBParameterGroups = new ArrayList<DBParameterGroupStatus>();
        }
        return this.dBParameterGroups;
    }

    public void setDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        if (dBParameterGroups == null) {
            this.dBParameterGroups = null;
            return;
        }
        ArrayList<DBParameterGroupStatus> dBParameterGroupsCopy = new ArrayList<DBParameterGroupStatus>(dBParameterGroups.size());
        dBParameterGroupsCopy.addAll(dBParameterGroups);
        this.dBParameterGroups = dBParameterGroupsCopy;
    }

    public DBInstance withDBParameterGroups(DBParameterGroupStatus ... dBParameterGroups) {
        if (this.getDBParameterGroups() == null) {
            this.setDBParameterGroups(new ArrayList<DBParameterGroupStatus>(dBParameterGroups.length));
        }
        for (DBParameterGroupStatus value : dBParameterGroups) {
            this.getDBParameterGroups().add(value);
        }
        return this;
    }

    public DBInstance withDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        if (dBParameterGroups == null) {
            this.dBParameterGroups = null;
        } else {
            ArrayList<DBParameterGroupStatus> dBParameterGroupsCopy = new ArrayList<DBParameterGroupStatus>(dBParameterGroups.size());
            dBParameterGroupsCopy.addAll(dBParameterGroups);
            this.dBParameterGroups = dBParameterGroupsCopy;
        }
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public DBInstance withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public DBInstance withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public DBInstance withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public DBInstance withLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public DBInstance withMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
        return this;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public DBInstance withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public DBInstance withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String getReadReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
    }

    public DBInstance withReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        return this;
    }

    public List<String> getReadReplicaDBInstanceIdentifiers() {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = new ArrayList<String>();
        }
        return this.readReplicaDBInstanceIdentifiers;
    }

    public void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
            return;
        }
        ArrayList<String> readReplicaDBInstanceIdentifiersCopy = new ArrayList<String>(readReplicaDBInstanceIdentifiers.size());
        readReplicaDBInstanceIdentifiersCopy.addAll(readReplicaDBInstanceIdentifiers);
        this.readReplicaDBInstanceIdentifiers = readReplicaDBInstanceIdentifiersCopy;
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
        if (this.getReadReplicaDBInstanceIdentifiers() == null) {
            this.setReadReplicaDBInstanceIdentifiers(new ArrayList<String>(readReplicaDBInstanceIdentifiers.length));
        }
        for (String value : readReplicaDBInstanceIdentifiers) {
            this.getReadReplicaDBInstanceIdentifiers().add(value);
        }
        return this;
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
        } else {
            ArrayList<String> readReplicaDBInstanceIdentifiersCopy = new ArrayList<String>(readReplicaDBInstanceIdentifiers.size());
            readReplicaDBInstanceIdentifiersCopy.addAll(readReplicaDBInstanceIdentifiers);
            this.readReplicaDBInstanceIdentifiers = readReplicaDBInstanceIdentifiersCopy;
        }
        return this;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public DBInstance withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dBInstanceIdentifier != null) {
            sb.append("DBInstanceIdentifier: " + this.dBInstanceIdentifier + ", ");
        }
        if (this.dBInstanceClass != null) {
            sb.append("DBInstanceClass: " + this.dBInstanceClass + ", ");
        }
        if (this.engine != null) {
            sb.append("Engine: " + this.engine + ", ");
        }
        if (this.dBInstanceStatus != null) {
            sb.append("DBInstanceStatus: " + this.dBInstanceStatus + ", ");
        }
        if (this.masterUsername != null) {
            sb.append("MasterUsername: " + this.masterUsername + ", ");
        }
        if (this.dBName != null) {
            sb.append("DBName: " + this.dBName + ", ");
        }
        if (this.endpoint != null) {
            sb.append("Endpoint: " + this.endpoint + ", ");
        }
        if (this.allocatedStorage != null) {
            sb.append("AllocatedStorage: " + this.allocatedStorage + ", ");
        }
        if (this.instanceCreateTime != null) {
            sb.append("InstanceCreateTime: " + this.instanceCreateTime + ", ");
        }
        if (this.preferredBackupWindow != null) {
            sb.append("PreferredBackupWindow: " + this.preferredBackupWindow + ", ");
        }
        if (this.backupRetentionPeriod != null) {
            sb.append("BackupRetentionPeriod: " + this.backupRetentionPeriod + ", ");
        }
        if (this.dBSecurityGroups != null) {
            sb.append("DBSecurityGroups: " + this.dBSecurityGroups + ", ");
        }
        if (this.dBParameterGroups != null) {
            sb.append("DBParameterGroups: " + this.dBParameterGroups + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.preferredMaintenanceWindow != null) {
            sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        }
        if (this.pendingModifiedValues != null) {
            sb.append("PendingModifiedValues: " + this.pendingModifiedValues + ", ");
        }
        if (this.latestRestorableTime != null) {
            sb.append("LatestRestorableTime: " + this.latestRestorableTime + ", ");
        }
        if (this.multiAZ != null) {
            sb.append("MultiAZ: " + this.multiAZ + ", ");
        }
        if (this.engineVersion != null) {
            sb.append("EngineVersion: " + this.engineVersion + ", ");
        }
        if (this.autoMinorVersionUpgrade != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        }
        if (this.readReplicaSourceDBInstanceIdentifier != null) {
            sb.append("ReadReplicaSourceDBInstanceIdentifier: " + this.readReplicaSourceDBInstanceIdentifier + ", ");
        }
        if (this.readReplicaDBInstanceIdentifiers != null) {
            sb.append("ReadReplicaDBInstanceIdentifiers: " + this.readReplicaDBInstanceIdentifiers + ", ");
        }
        if (this.licenseModel != null) {
            sb.append("LicenseModel: " + this.licenseModel + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceStatus() == null ? 0 : this.getDBInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreateTime() == null ? 0 : this.getInstanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroups() == null ? 0 : ((Object)this.getDBSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroups() == null ? 0 : ((Object)this.getDBParameterGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZ() == null ? 0 : this.isMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaSourceDBInstanceIdentifier() == null ? 0 : this.getReadReplicaSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaDBInstanceIdentifiers() == null ? 0 : ((Object)this.getReadReplicaDBInstanceIdentifiers()).hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getDBInstanceStatus() == null ^ this.getDBInstanceStatus() == null) {
            return false;
        }
        if (other.getDBInstanceStatus() != null && !other.getDBInstanceStatus().equals(this.getDBInstanceStatus())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getInstanceCreateTime() == null ^ this.getInstanceCreateTime() == null) {
            return false;
        }
        if (other.getInstanceCreateTime() != null && !other.getInstanceCreateTime().equals(this.getInstanceCreateTime())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getDBSecurityGroups() == null ^ this.getDBSecurityGroups() == null) {
            return false;
        }
        if (other.getDBSecurityGroups() != null && !((Object)other.getDBSecurityGroups()).equals(this.getDBSecurityGroups())) {
            return false;
        }
        if (other.getDBParameterGroups() == null ^ this.getDBParameterGroups() == null) {
            return false;
        }
        if (other.getDBParameterGroups() != null && !((Object)other.getDBParameterGroups()).equals(this.getDBParameterGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.isMultiAZ() == null ^ this.isMultiAZ() == null) {
            return false;
        }
        if (other.isMultiAZ() != null && !other.isMultiAZ().equals(this.isMultiAZ())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() == null ^ this.getReadReplicaSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() != null && !other.getReadReplicaSourceDBInstanceIdentifier().equals(this.getReadReplicaSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() == null ^ this.getReadReplicaDBInstanceIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() != null && !((Object)other.getReadReplicaDBInstanceIdentifiers()).equals(this.getReadReplicaDBInstanceIdentifiers())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        return other.getLicenseModel() == null || other.getLicenseModel().equals(this.getLicenseModel());
    }
}

