/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceNetworkAclEntryRequestMarshaller
implements Marshaller<Request<ReplaceNetworkAclEntryRequest>, ReplaceNetworkAclEntryRequest> {
    @Override
    public Request<ReplaceNetworkAclEntryRequest> marshall(ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {
        PortRange portRangePortRange;
        IcmpTypeCode icmpTypeCodeIcmpTypeCode;
        if (replaceNetworkAclEntryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReplaceNetworkAclEntryRequest> request = new DefaultRequest<ReplaceNetworkAclEntryRequest>(replaceNetworkAclEntryRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceNetworkAclEntry");
        request.addParameter("Version", "2011-12-15");
        if (replaceNetworkAclEntryRequest.getNetworkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString(replaceNetworkAclEntryRequest.getNetworkAclId()));
        }
        if (replaceNetworkAclEntryRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger(replaceNetworkAclEntryRequest.getRuleNumber()));
        }
        if (replaceNetworkAclEntryRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(replaceNetworkAclEntryRequest.getProtocol()));
        }
        if (replaceNetworkAclEntryRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString(replaceNetworkAclEntryRequest.getRuleAction()));
        }
        if (replaceNetworkAclEntryRequest.isEgress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean(replaceNetworkAclEntryRequest.isEgress()));
        }
        if (replaceNetworkAclEntryRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(replaceNetworkAclEntryRequest.getCidrBlock()));
        }
        if ((icmpTypeCodeIcmpTypeCode = replaceNetworkAclEntryRequest.getIcmpTypeCode()) != null) {
            if (icmpTypeCodeIcmpTypeCode.getType() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger(icmpTypeCodeIcmpTypeCode.getType()));
            }
            if (icmpTypeCodeIcmpTypeCode.getCode() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger(icmpTypeCodeIcmpTypeCode.getCode()));
            }
        }
        if ((portRangePortRange = replaceNetworkAclEntryRequest.getPortRange()) != null) {
            if (portRangePortRange.getFrom() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger(portRangePortRange.getFrom()));
            }
            if (portRangePortRange.getTo() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger(portRangePortRange.getTo()));
            }
        }
        return request;
    }
}

