/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.networkspec.Choice;
import com.norbl.cbp.ppe.gui.networkspec.OtherCC;
import com.norbl.cbp.ppe.gui.networkspec.RadioButtonCC;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class AmiChoice
extends Choice {
    AmiPPE ami;
    String value;

    public AmiChoice(AmiPPE ami) {
        this.ami = ami;
    }

    public AmiChoice() {
        this.ami = null;
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getValue() {
        if (this.ami != null) {
            return this.ami.amiID;
        }
        if (this.cc instanceof OtherCC) {
            return ((OtherCC)this.cc).textField.getText();
        }
        if (this.value != null) {
            return this.value;
        }
        throw new RuntimeException("No image or value, cc: " + this.cc);
    }

    @Override
    public String getLabel() {
        if (this.ami != null) {
            return this.ami.amiID;
        }
        if (this.cc instanceof OtherCC || this.value != null) {
            return "Other: ";
        }
        throw new RuntimeException("No image, cc: " + this.cc);
    }

    @Override
    public void createCC() {
        if (this.ami != null) {
            this.cc = new RadioButtonCC(this.getLabel());
        } else {
            this.cc = new OtherCC();
            ((OtherCC)this.cc).setOtherLabel();
            ((OtherCC)this.cc).createComponents();
            ((OtherCC)this.cc).populate();
        }
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AmiChoice)) {
            return false;
        }
        AmiChoice o = (AmiChoice)other;
        return this.getValue().equals(o.getValue()) && this.getLabel().equals(o.getLabel());
    }

    public boolean usesParavirtual() {
        if (this.ami == null) {
            return false;
        }
        return Ec2InstanceType.isPv(this.ami.getVirtualizationType());
    }

    public boolean usesHvm() {
        if (this.ami == null) {
            return false;
        }
        return Ec2InstanceType.isHvm(this.ami.getVirtualizationType());
    }

    @Override
    public abstract int getNColumns();

    @Override
    public abstract Object getValue(int var1);

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract double getColumnWeight(int var1);

    @Override
    public abstract int getGridBagAnchor(int var1);

    @Override
    public abstract Insets getInsets(int var1);

    @Override
    public JComponent getComponent(int iCol) {
        JLabel x = new JLabel(this.toStringNullSpace(this.getValue(iCol)));
        if (iCol == 1) {
            x.setMinimumSize(new Dimension(150, x.getPreferredSize().height));
            x.setPreferredSize(new Dimension(150, x.getPreferredSize().height));
        }
        return x;
    }

    private String toStringNullSpace(Object x) {
        if (x != null) {
            return x.toString();
        }
        return " ";
    }

    private String booToString(boolean b) {
        if (b) {
            return "yes";
        }
        return "no";
    }

    private String listToString(List<String> strs) {
        if (strs.size() < 1) {
            return "";
        }
        int i = 0;
        StringBuilder s = new StringBuilder();
        for (String str : strs) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(str);
            ++i;
        }
        return s.toString();
    }

    protected String getUnauthorizedToolTipMessage() {
        if (this.ami.isUsableReBilling(PPEManager.paramsEc2)) {
            return null;
        }
        return "To use this AMI, you must authorize billing.<br>Use 'Account -> Authorize instance billing'";
    }
}

