/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.norbl.cbp.ppe.gui.networkspec.ChoiceComponent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OtherCC
extends JPanel
implements ChoiceComponent {
    public static String OTHER_LABEL = "Other: ";
    String label;
    JRadioButton button;
    JTextField textField;
    public boolean populated = false;

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOtherLabel() {
        this.setLabel(OTHER_LABEL);
    }

    public void createComponents() {
        this.button = new JRadioButton();
        if (this.label.toLowerCase().startsWith("other")) {
            this.button.setMaximumSize(ChoiceComponent.BUTTON_SIZE);
            this.button.setMinimumSize(ChoiceComponent.BUTTON_SIZE);
            this.button.setFont(ChoiceComponent.CHOICE_FONT);
        } else {
            this.button.setFont(ChoiceComponent.CHOICE_FONT);
        }
        this.button.setText(this.label);
        this.textField = new JTextField();
        this.textField.setText("");
        this.textField.setMaximumSize(ChoiceComponent.TEXT_FIELD_SIZE);
        this.textField.setMinimumSize(ChoiceComponent.TEXT_FIELD_SIZE);
        this.textField.setPreferredSize(ChoiceComponent.TEXT_FIELD_SIZE);
        this.setEnabled(true);
        this.button.setSelected(false);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void populate() {
        if (this.isPopulated()) {
            return;
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.button);
        this.add(this.textField);
        this.populated = true;
    }

    public void repopulate(JFrame parentFrame) {
        if (this.isPopulated()) {
            return;
        }
        this.populate();
        this.validate();
        parentFrame.repaint();
    }

    public void depopulate(JFrame parentFrame) {
        if (!this.isPopulated()) {
            return;
        }
        this.removeAll();
        this.revalidate();
        parentFrame.repaint();
        this.populated = false;
    }

    @Override
    public boolean isSelected() {
        return this.button.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    @Override
    public void setSelected(boolean selected) {
        this.button.setSelected(selected);
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.button;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.button.addActionListener(actionListener);
        this.textField.addActionListener(actionListener);
    }

    @Override
    public void setActionCommand(String cmd) {
        this.textField.setActionCommand(cmd);
        this.button.setActionCommand(cmd);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

