% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctg_count.R
\name{ctg_count}
\alias{ctg_count}
\title{Get Count of Clinical Trials from ClinicalTrials.gov}
\usage{
ctg_count(
  condition = NULL,
  location = NULL,
  title = NULL,
  intervention = NULL,
  status = NULL
)
}
\arguments{
\item{condition}{A character string specifying the condition being studied (default: NULL).}

\item{location}{A character string specifying the location of the trials (default: NULL).}

\item{title}{A character string specifying keywords in the study title (default: NULL).}

\item{intervention}{A character string specifying the type of intervention (default: NULL).}

\item{status}{A character vector specifying the recruitment status of the trials. Allowed values are:
              Valid values include:
              \itemize{
                \item \code{ACTIVE_NOT_RECRUITING} - Studies that are actively conducting but not
                      recruiting participants.
                \item \code{COMPLETED} - Studies that have completed all phases.
                \item \code{ENROLLING_BY_INVITATION} - Studies that are enrolling participants
                      by invitation only.
                \item \code{NOT_YET_RECRUITING} - Studies that have not yet started recruiting.
                \item \code{RECRUITING} - Studies that are actively recruiting participants.
                \item \code{SUSPENDED} - Studies that are temporarily halted.
                \item \code{TERMINATED} - Studies that have been terminated before completion.
                \item \code{WITHDRAWN} - Studies that have been withdrawn before enrollment.
                \item \code{AVAILABLE} - Studies that are available.
                \item \code{NO_LONGER_AVAILABLE} - Studies that are no longer available.
                \item \code{TEMPORARILY_NOT_AVAILABLE} - Studies that are temporarily not available.
                \item \code{APPROVED_FOR_MARKETING} - Studies that have been approved for marketing.
                \item \code{WITHHELD} - Studies that have data withheld.
                \item \code{UNKNOWN} - Studies with an unknown status.
              }
Default is NULL.}
}
\value{
A number representing the total count of clinical trials matching the specified parameters.
}
\description{
This function retrieves the count of clinical trials from ClinicalTrials.gov based on specified parameters.
}
\examples{
ctg_count(
  condition = "Cancer",
  location = "India",
  title = NULL,
  intervention = "Drug",
  status = "RECRUITING"
)
}
