% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{tbl}
\alias{tbl}
\title{Create a table (tbl)}
\usage{
tbl(df,strata,vars,render.numeric,
render.factor, tests, paired,
   digs_n,digs_f, digs_p, digs_s,
   only_stats, strata.fixed, strata.random,
   time.to, present.missing, markdown, caption)
}
\arguments{
\item{df}{dataframe. (\code{df})}

\item{strata}{Column name of stratification (\code{string})}

\item{vars}{Column names of variables of interest (\code{list})}

\item{render.numeric}{list of presentation of numeric variables (\code{list})}

\item{render.factor}{presentation of factors, with \code{simple} removing one factor when only two exists}

\item{tests}{list of tests carried out, currently the following works: \code{t.test}, \code{wilcox.test}, \code{fisher.test}, \code{auc}, \code{lm}, and \code{glm}. (\code{list})}

\item{paired}{if tests should be paired (\code{boolean})}

\item{digs_n}{digits for numeric (\code{numeric})}

\item{digs_f}{digits for factors (\code{numeric})}

\item{digs_p}{digits for p-values (\code{numeric})}

\item{digs_s}{digits for statistics (\code{numeric})}

\item{only_stats}{if only stats should be presented (\code{booolean})}

\item{strata.fixed}{list of columns which should be used as fixed stratification (\code{list})}

\item{strata.random}{list of columns which should be used as random stratification (\code{list})}

\item{time.to}{Column name of the time column for cox regression (\code{list})}

\item{present.missing}{default is dynamic where non-missing variables are not presented.}

\item{markdown}{default is true and output is pander, while false output is a dataframe (\code{boolean})}

\item{caption}{Table caption only in use when markdown is true (\code{string})}
}
\value{
Returns summarised information in dataframe.
}
\description{
\code{tbl()} is a function which create a dataframe, which can be copied directly into
word or presented in as a summary table.
}
\examples{
\dontrun{
   hmm <- tbl(df,strata="group",
   vars = c("Gestational Age at birth","Maternal preeclampsia"),
   tests=c("wilcox.test","glm"),only_stats=F,strata.random = "site",
   markdown=F)
   pander::pander(hmm, keep.line.breaks = TRUE,split.tables=Inf, row.names = F)
}

}
