% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_clintable}
\alias{write_clintable}
\title{Clintable write method}
\usage{
write_clintable(x, file, apply_defaults = TRUE)
}
\arguments{
\item{x}{a clintable object}

\item{file}{The file path to which the file should be written}

\item{apply_defaults}{Apply default styles. These styles are stored in the
options clinify_header_default, clinify_footer_default, and
clinify_table_default respectively. Defaults to true.}
}
\value{
Invisible
}
\description{
Write a clinify table out to a docx file
}
\examples{
ct <- clintable(mtcars)

ct <- clin_alt_pages(
  ct,
  key_cols = c('mpg', 'cyl', 'hp'),
  col_groups = list(
    c('disp', 'drat', 'wt'),
    c('qsec', 'vs', 'am'),
    c('gear', 'carb')
  )
)

write_clintable(ct, file.path(tempdir(), 'demo.docx'))

}
