% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-referenceLines.R
\name{addReferenceLinesClinDataPlot}
\alias{addReferenceLinesClinDataPlot}
\title{Add reference (horizontal/vertical/diagonal) lines
to a clinical data plot}
\usage{
addReferenceLinesClinDataPlot(
  gg,
  data,
  xVar,
  yVar,
  xLim = NULL,
  yLim = NULL,
  refLinePars = NULL,
  facetPars = NULL
)
}
\arguments{
\item{gg}{\code{\link[ggplot2]{ggplot}} object.}

\item{data}{Data.frame with data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{xLim, yLim}{Numeric vector of length 2 with limits for the x/y axes.}

\item{refLinePars}{(optional) Nested list, with parameters for each reference line(s).
Each sublist (a.k.a reference line) contains:
\itemize{
\item aesthetic value(s) or variable(s) for the lines
(in this case column names of \code{data}) for reference lines.
The line position is controlled by the aesthetics supported in
\code{\link[ggplot2]{geom_vline}}, \code{\link[ggplot2]{geom_hline}} 
and \code{\link[ggplot2]{geom_abline}}.
\item 'label': (optional) Logical specifying if the line
should be annotated (\code{FALSE} to not annotate the line)
or string with annotation label. By default, the value
of the position of the horizontal/vertical line or the equation
of the diagonal line is displayed.
}}

\item{facetPars}{List with facetting parameters, 
passed to the facetting function. Variables should be specified
as character or formula.
For 'wrap' facetting (\code{facetType} is 'wrap'), if the layout
is not specified via \code{nrow}/\code{ncol}, 2 columns
are used by default.}
}
\value{
Updated \code{\link[ggplot2]{ggplot}} object.
}
\description{
Add reference (horizontal/vertical/diagonal) lines
to a clinical data plot
}
\author{
Laure Cougnaud
}
