% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_imgw_monthly.R
\name{meteo_imgw_monthly}
\alias{meteo_imgw_monthly}
\title{Monthly IMGW meteorological data}
\usage{
meteo_imgw_monthly(
  rank = "synop",
  year,
  status = FALSE,
  coords = FALSE,
  station = NULL,
  col_names = "short",
  ...
)
}
\arguments{
\item{rank}{rank of the stations: "synop" (default), "climate", or "precip"}

\item{year}{vector of years (e.g., 1966:2000)}

\item{status}{leave the columns with measurement and observation statuses (default status = FALSE - i.e. the status columns are deleted)}

\item{coords}{add coordinates of the station (logical value TRUE or FALSE)}

\item{station}{name or ID of meteorological station(s).
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\description{
Downloading monthly (meteorological) data from the SYNOP / CLIMATE / PRECIP stations available in the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
  monthly <- meteo_imgw_monthly(rank = "climate", year = 1969)
  head(monthly)

  # a descriptive (long) column names:
  monthly2 <- meteo_imgw_monthly(rank = "synop", year = 2018, 
         col_names = "full")
  head(monthly2)
  
  # please note that station names may change over time 
  # and thus 2 names are required in some cases:
  df = meteo_imgw_monthly(rank = 'synop', year = 1991:2000, 
          coords = TRUE, station = c("POZNAŃ","POZNAŃ-ŁAWICA")) 
}

}
