% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_last_obs.R
\name{aemet_last_obs}
\alias{aemet_last_obs}
\title{Last observation values for a station}
\usage{
aemet_last_obs(station = "all", verbose = FALSE, return_sf = FALSE)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}) or "all" for all the stations.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}
}
\value{
A tibble or a \code{sf} object.
}
\description{
Get last observation values for a station.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
obs <- aemet_last_obs(c("9434", "3195"))
glimpse(obs)
\dontshow{\}) # examplesIf}
}
\seealso{
Other aemet_api_data: 
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
