% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{fix_factors}
\alias{fix_factors}
\title{Fix factors imported as numerics}
\usage{
fix_factors(x, k = 5, drop = TRUE, track = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{k}{Maximum number of different numeric values to be converted to factor}

\item{drop}{Drop similar levels?}

\item{track}{Keep track of changes?}
}
\description{
Fixes factors imported as numerics. It is usual in some fields to encode
factor variables as integers. This function detects such variables and transforms
them into factors. When \code{drop=TRUE} (by default) it detects multiple versions
of the same levels due to different capitalization, whitespaces or non-ASCII characters.
}
\examples{
# mtcars data has all variables encoded as numeric, even the factor variables.
descriptive(mtcars)
# After using fix_factors, factor variables are recognized as such.
descriptive(fix_factors(mtcars))
}
