% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{get_function_body}
\alias{get_function_body}
\title{get the body of a function}
\usage{
get_function_body(object)
}
\arguments{
\item{object}{The function from which to extract the body. \cr Should have
been sourced with keep.source = TRUE.}
}
\value{
[character(n)]\cr the function body's lines.
}
\description{
\code{\link{body}} reformats the code (see \emph{Examples} and
\emph{Details}).
}
\details{
If we want to check a function as it is coded in a file, we need to get the
original thing as coded in the file, no optimized version.
In \code{\link{sys.source}} and \code{\link{source}}, keep.source = FALSE
seems to use \code{\link{body}}.
So we have to do it all over after sourcing with keep.source = TRUE (in
\code{\link{check_functions_in_file}}).
}
\examples{
source(system.file("source", "R", "utils.R", package = "cleanr"))
require(checkmate)
cleanr:::get_function_body(set_cleanr_options)[3:6]
utils::capture.output(body(set_cleanr_options))[4:6]
}
\author{
Andreas Dominik Cullmann, <adc-r@arcor.de>
}
\keyword{internal}

