% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{set_properties}
\alias{set_properties}
\title{Set properties for the coreNLP pipeline}
\usage{
set_properties(keys, values, clear = FALSE)
}
\arguments{
\item{keys}{a character vector of keys giving the names of the properties to set}

\item{values}{a character vector the same length of keys giving the values to set
each respective property to}

\item{clear}{should the set of properties be cleared before setting these values}
}
\description{
This function allows for directly setting properties to be passed on to the
Stanford CoreNLP pipeline. This will generally be of interest to experienced
users who are already familiar with the general pipeline. See the function
\code{\link{set_language}} for a more user-friendly approach.
}
\examples{
\dontrun{
set_properties("annotators", "segment, ssplit, tokenize, pos")
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}

