\name{getAcc}
\alias{getAcc}
\title{
Get the accuracies of a classification ensemble
}
\description{
The \code{getAcc} function returns the test and train accuracies for all the classifiers within a classification ensemble as generated by \code{\link{cfBuild}}.
}
\usage{
getAcc(ensObj)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
}
\value{
The \code{getAcc} function returns a list with two named (\code{Test} and \code{Train}) vectors, equal to the overall test accuracies (\%CC) and overall train accuracies of the classifiers within the ensemble. The attributes of the list can be accessed by executing the \link{attributes} command.
}
\seealso{
  \code{\link{getAvgAcc}}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

ens <- cfBuild(inputData = irisData, inputClass = irisClass, bootNum = 100, 
               ensNum = 100, parallel = TRUE, cpus = 4, type = "SOCK")

attributes(getAcc(ens))

# Get the test and train accuracies of the classifiers in the ensemble
getAcc(ens)

# Get the test accuracies of the classifiers in the ensemble
getAcc(ens)$Test

# Get the train accuracies of the classifiers in the ensemble
getAcc(ens)$Train
}
}
\keyword{array}
