% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clam.R
\name{student.t}
\alias{student.t}
\title{Comparison dates calibrated using both the student-t distribution and the the normal distribution.}
\usage{
student.t(y = 2450, error = 50, t.a = 3, t.b = 4, cc = 1,
  postbomb = c(), cc1 = "IntCal13", cc2 = "Marine13", cc3 = "SHCal13",
  cc4 = "mixed", ccdir = "", Cutoff = 1e-05, times = 8)
}
\arguments{
\item{y}{The reported mean of the date.}

\item{error}{The reported error of the date.}

\item{t.a}{Value for the student-t parameter \code{a}.}

\item{t.b}{Value for the student-t parameter \code{b}.}

\item{cc}{calibration curve for C14 dates (1, 2 or 3).}

\item{postbomb}{Which postbomb curve to use for negative 14C dates}

\item{cc1}{For northern hemisphere terrestrial C14 dates.}

\item{cc2}{For marine C14 dates.}

\item{cc3}{For southern hemisphere C14 dates.}

\item{cc4}{A custom calibration curve}

\item{ccdir}{Directory where the calibration curves for C14 dates \code{cc} are allocated. By default \code{ccdir=""}. 
Use \code{ccdir="."} to choose current working directory. Use \code{ccdir="Curves/"} to choose sub-folder \code{Curves/}.}

\item{Cutoff}{Threshold above which calibrated probabilities are plotted}

\item{times}{8 by default.}
}
\description{
Visualise how a date calibrates using the student-t distribution and the the normal distribution.
}
\details{
Radiocarbon and other dates are usually modelled using the normal distribution (red curve). The student-t approach (grey distribution) however allows for wider tails and thus tends to better accommodate outlying dates. This distribution requires two parameters, called 'a' and 'b'.
}
\examples{
student.t() 

}
\references{
Christen, J.A., P{\'e}rez, S. E., 2009. A new robust statistical model for radiocarbon data. Radiocarbon 51 (3), 1047-1059
\url{https://journals.uair.arizona.edu/index.php/radiocarbon/article/view/3562}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/clam.html}
}
\author{
Maarten Blaauw
}
