% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_create.R
\name{user_create}
\alias{user_create}
\title{Create a user.}
\usage{
user_create(
  name,
  email,
  password,
  id = NULL,
  fullname = NULL,
  about = NULL,
  openid = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{name}{(character) the name of the new user, a string between 2 and 100
characters in length, containing only lowercase alphanumeric
characters, - and _ (required)}

\item{email}{(character) the email address for the new user (required)}

\item{password}{(character) the password of the new user, a string of at
least 4 characters (required)}

\item{id}{(character) the id of the new user (optional)}

\item{fullname}{(character) user full name}

\item{about}{(character) a description of the new user (optional)}

\item{openid}{(character) an openid (optional)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Create a user.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://data-demo.dpaw.wa.gov.au",
  key = "824e7c50-9577-4bfa-bf32-246ebed1a8a2")

# create a user
user_create(name = 'stacy', email = "stacy@aaaaa.com",
password = "helloworld")
}
}
\references{
http://docs.ckan.org/en/latest/api/index.html#ckan.logic.action.create.user_create
}
