% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_create.R
\name{resource_create}
\alias{resource_create}
\title{Create a resource}
\usage{
resource_create(package_id = NULL, rcurl = NULL, revision_id = NULL,
  description = NULL, format = NULL, hash = NULL, name = NULL,
  resource_type = NULL, mimetype = NULL, mimetype_inner = NULL,
  webstore_url = NULL, cache_url = NULL, size = NULL,
  created = NULL, last_modified = NULL, cache_last_updated = NULL,
  webstore_last_updated = NULL, upload = NULL,
  url = get_default_url(), key = get_default_key(), as = "list", ...)
}
\arguments{
\item{package_id}{(character) id of package that the resource should be added to.
This should be an alphanumeric string. Required.}

\item{rcurl}{(character) url of resource. Required.}

\item{revision_id}{(character) revision id (optional)}

\item{description}{(character) description (optional). Required.}

\item{format}{(character) format (optional)}

\item{hash}{(character) hash (optional)}

\item{name}{(character) name (optional). Required.}

\item{resource_type}{(character) resource type (optional)}

\item{mimetype}{(character) mime type (optional)}

\item{mimetype_inner}{(character) mime type inner (optional)}

\item{webstore_url}{(character) webstore url (optional)}

\item{cache_url}{(character) cache url(optional)}

\item{size}{(integer) size (optional)}

\item{created}{(character) iso date string (optional)}

\item{last_modified}{(character) iso date string (optional)}

\item{cache_last_updated}{(character) iso date string (optional)}

\item{webstore_last_updated}{(character) iso date string (optional)}

\item{upload}{(character) A path to a local file (optional)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Create a resource
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("foobarrrr", author="Jane Doe"))

# then create a resource
file <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
(xx <- resource_create(package_id = res$id,
                       description = "my resource",
                       name = "bears",
                       upload = file,
                       rcurl = "http://google.com"
))

package_create("foobbbbbarrrr") \%>\%
   resource_create(description = "my resource",
                   name = "bearsareus",
                   upload = file,
                   rcurl = "http://google.com")
}
}
