% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/package_delete.R
\name{package_delete}
\alias{package_delete}
\title{Delete a package}
\usage{
package_delete(id, key = get_default_key(), url = get_default_url(), ...)
}
\arguments{
\item{id}{(character) The id of the package. Required.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Delete a package
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("lions-bears-tigers"))

# show the package
package_show(res)

# delete the package
package_delete(res)
}
}

