% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing_values.R
\name{impute_missing_values}
\alias{impute_missing_values}
\title{Impute missing values in a dataframe and add missingness indicators.}
\usage{
impute_missing_values(data, type = "standard", add_indicators = T,
  prefix = "miss_", skip_vars = c(), verbose = F)
}
\arguments{
\item{data}{Dataframe or matrix.}

\item{type}{"knn" or "standard" (median/mode). NOTE: knn will result in the
data being centered and scaled!}

\item{add_indicators}{Add a series of missingness indicators.}

\item{prefix}{String to add at the beginning of the name of each missingness
indicator.}

\item{skip_vars}{List of variable names to exclude from the imputation.}

\item{verbose}{If True display extra information during execution.}
}
\value{
List with the following elements:
\itemize{
\item $data - imputed dataset.
\item $impute_info - if knn, caret preprocess element for imputing test data.
\item $impute_values - if standard, list of imputation values for each variable.
}
}
\description{
Impute missing values, using knn by default or alternatively
  median-impute numerics, mode-impute factors. Add missingness indicators.
}
\examples{

# Load a test dataset.
data(PimaIndiansDiabetes2, package = "mlbench")

# Check for missing values.
colSums(is.na(PimaIndiansDiabetes2))

# Impute missing data and add missingness indicators.
# Don't impute the outcome though.
result = impute_missing_values(PimaIndiansDiabetes2, skip_vars = "diabetes")

# Confirm we have no missing data.
colSums(is.na(result$data))


#############
# K-nearest neighbors imputation

result2 = impute_missing_values(PimaIndiansDiabetes2, type = "knn", skip_vars = "diabetes")

# Confirm we have no missing data.
colSums(is.na(result2$data))

}
\seealso{
\code{\link{missingness_indicators}} \code{\link[caret]{preProcess}}
}
