% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{queries_post}
\alias{queries_post}
\title{Execute a query}
\usage{
queries_post(database, sql, preview_rows, credential = NULL, hidden = NULL,
  interactive = NULL, include_header = NULL, compression = NULL,
  column_delimiter = NULL, unquoted = NULL, filename_prefix = NULL)
}
\arguments{
\item{database}{integer required. The database ID.}

\item{sql}{string required. The SQL to execute.}

\item{preview_rows}{integer required. The number of rows to save from the query's result (maximum: 100).}

\item{credential}{integer optional. The credential ID.}

\item{hidden}{boolean optional. The hidden status of the item.}

\item{interactive}{boolean optional. Deprecated and not used.}

\item{include_header}{boolean optional. Whether the CSV output should include a header row [default: true].}

\item{compression}{string optional. The type of compression. One of gzip or zip, or none [default: gzip].}

\item{column_delimiter}{string optional. The delimiter to use. One of comma or tab, or pipe [default: comma].}

\item{unquoted}{boolean optional. If true, will not quote fields.}

\item{filename_prefix}{string optional. The output filename prefix.}
}
\value{
A list containing the following elements:
\item{id}{integer, The query ID.}
\item{database}{integer, The database ID.}
\item{sql}{string, The SQL to execute.}
\item{credential}{integer, The credential ID.}
\item{resultRows}{array, A preview of rows returned by the query.}
\item{resultColumns}{array, A preview of columns returned by the query.}
\item{scriptId}{integer, The ID of the script associated with this query.}
\item{exception}{string, Deprecated and not used.}
\item{error}{string, The error message for this run, if present.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run.}
\item{lastRunId}{integer, The ID of the last run.}
\item{hidden}{boolean, The hidden status of the item.}
\item{interactive}{boolean, Deprecated and not used.}
\item{previewRows}{integer, The number of rows to save from the query's result (maximum: 100).}
\item{includeHeader}{boolean, Whether the CSV output should include a header row [default: true].}
\item{compression}{string, The type of compression. One of gzip or zip, or none [default: gzip].}
\item{columnDelimiter}{string, The delimiter to use. One of comma or tab, or pipe [default: comma].}
\item{unquoted}{boolean, If true, will not quote fields.}
\item{filenamePrefix}{string, The output filename prefix.}
\item{startedAt}{string, The start time of the last run.}
\item{reportId}{integer, The ID of the report associated with this query.}
}
\description{
Execute a query
}
