% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrument_oop.R
\name{instrument}
\alias{instrument}
\title{Load a specific instrument object}
\usage{
instrument(code)
}
\arguments{
\item{code}{Required. A string (e.g., "iip32") or text in non-standard
evaluation (e.g., iip32). The code of the instrument assigned by this
package and displayed in parentheses by \code{instruments()}.}
}
\value{
The instrument object for the requested circumplex instrument. If
the function is called without a name assignment (LHS), then the object
will be created in the global environment with the default name as above.
Or, if a name is assigned (LHS), the object will have that name instead.
}
\description{
The circumplex package includes information about numerous circumplex
instruments including instructions for scoring and standardizing items to be
used in conjunction with the \code{score} and \code{standardize} functions.
This function loads the information for a specific instrument into memory.
See the \code{instruments} function to list all available instruments.
}
\examples{
instrument(iip32)
instrument("iip32")
x <- instrument(iip32)
}
\seealso{
Other instrument functions: \code{\link{anchors}},
  \code{\link{instruments}}, \code{\link{items}},
  \code{\link{norms}}, \code{\link{scales}}
}
\concept{instrument functions}
