% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccXaxis}
\alias{ccXaxis}
\title{Draw x-axis}
\usage{
ccXaxis(
  h = "top",
  major.at = NULL,
  labels = TRUE,
  major.tick = TRUE,
  labels.font = par("font"),
  labels.cex = par("cex"),
  labels.facing = "inside",
  labels.direction = NULL,
  labels.niceFacing = TRUE,
  direction = c("outside", "inside"),
  minor.ticks = 4,
  major.tick.length = NULL,
  lwd = par("lwd"),
  col = par("col"),
  labels.col = par("col"),
  labels.pos.adjust = TRUE
)
}
\arguments{
\item{h}{Position of the x-axis, can be "top", "bottom" or a numeric value}

\item{major.at}{If it is numeric vector, it identifies the positions of the major ticks. It can exceed \code{xlim} value and the exceeding part would be trimmed automatically. If it is \code{NULL}, about every 10 degrees there is a major tick.}

\item{labels}{labels of the major ticks. Also, the exceeding part would be trimmed automatically. The value can also be logical (either an atomic value or a vector) which represents which labels to show.}

\item{major.tick}{Whether to draw major tick. If it is set to \code{FALSE}, there will be no minor ticks neither.}

\item{labels.font}{Font style for the axis labels.}

\item{labels.cex}{Font size for the axis labels.}

\item{labels.facing}{Facing of labels on axis, passing to \code{\link[circlize]{circos.text}}}

\item{labels.direction}{Deprecated, use \code{facing} instead.}

\item{labels.niceFacing}{Should facing of axis labels be human-easy.}

\item{direction}{Whether the axis ticks point to the outside or inside of the circle.}

\item{minor.ticks}{Number of minor ticks between two close major ticks.}

\item{major.tick.length}{Length of the major ticks, measured in "current" data coordinate. \code{\link[circlize]{convert_y}} can be used to convert an absolute unit to the data coordinate.}

\item{lwd}{Line width for ticks.}

\item{col}{Color for the axes.}

\item{labels.col}{Color for the labels.}

\item{labels.pos.adjust}{Whether to adjust the positions of the first label and the last label so that the first label  align to its left and the last label align to its right if they exceed the range on axes. The value can be a vector of length two which correspond to the first label and the last label.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.axis]{circlize::circos.axis} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track <- ccTrack(ylim = c(0, 10))
cell <- ccCell(sector.index = "a") + ccXaxis()
track <- track + cell
cc + track
}
