% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_xifti_volume.R
\name{view_xifti_volume}
\alias{view_xifti_volume}
\alias{view_cifti_volume}
\alias{viewCIfTI_volume}
\alias{viewcii_volume}
\title{View subcortex}
\usage{
view_xifti_volume(
  xifti,
  structural_img = "MNI",
  idx = 1,
  plane = c("axial", "sagittal", "coronal"),
  num.slices = 9,
  interactive = FALSE,
  zlim = NULL,
  verbose = TRUE,
  ...
)

view_cifti_volume(
  xifti,
  structural_img = "MNI",
  idx = 1,
  plane = c("axial", "sagittal", "coronal"),
  num.slices = 9,
  interactive = FALSE,
  zlim = NULL,
  verbose = TRUE,
  ...
)

viewCIfTI_volume(
  xifti,
  structural_img = "MNI",
  idx = 1,
  plane = c("axial", "sagittal", "coronal"),
  num.slices = 9,
  interactive = FALSE,
  zlim = NULL,
  verbose = TRUE,
  ...
)

viewcii_volume(
  xifti,
  structural_img = "MNI",
  idx = 1,
  plane = c("axial", "sagittal", "coronal"),
  num.slices = 9,
  interactive = FALSE,
  zlim = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{xifti}{Object of class "xifti".
See \code{\link{is.xifti}} and \code{\link{make_xifti}}.}

\item{structural_img}{The structural MRI image on which to overlay the
subcortical values. Can be a file name, \code{"MNI"} (default) to use
the MNI T1-weighted template, or \code{NULL} to use a blank image.}

\item{idx}{The time/column index of the \code{"xifti"} data to plot. Must
be a single index (length 1).}

\item{plane}{If interactive=FALSE, the plane to display.
Default: \code{"axial"}. Other options are \code{"sagittal"} and
\code{"coronal"}.}

\item{num.slices}{If interactive=FALSE, the number of slices to display.
Default: \code{9}.}

\item{interactive}{interactive=TRUE will use papayar to allows for interactive visualization.}

\item{zlim}{A length-2 numeric vector giving the minimum and maximum values to
plot. Data values beyond this range will be truncated to the min/max. If
\code{NULL} (default), will use the min and max of the data.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}

\item{...}{Additional arguments to pass to \code{papayar::papaya} or \code{oro.nifti::overlay}}
}
\description{
Visualize subcortex of a \code{"xifti"} object
}
