% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cicc_plot.R
\name{cicc_plot}
\alias{cicc_plot}
\title{Plotting Upper Bounds on Relative and Attributable Risk}
\usage{
cicc_plot(
  results,
  parameter = "RR",
  sampling = "cc",
  save_plots = FALSE,
  file_name = Sys.Date(),
  plots_ctl = 0.3,
  plots_dir = FALSE
)
}
\arguments{
\item{results}{estimation results from either cicc_RR or cicc_AR}

\item{parameter}{'RR' for relative risk; 'AR' for attributable risk (default =  'RR')}

\item{sampling}{'cc' for case-control sampling; 'cp' for case-population sampling (default =  'cc')}

\item{save_plots}{TRUE if the plots are saved as pdf files; FALSE if not (default = FALSE)}

\item{file_name}{the pdf file name to save the plots (default = Sys.Date())}

\item{plots_ctl}{value to determine the topleft position of the legend in the figure
a large value makes the legend far away from the confidence intervals (default = 0.3)}

\item{plots_dir}{a directory where the plots are saved (default = FALSE);
plots will be saved under "(current working directory)/figures" by default.}
}
\value{
A X-Y plot where the X axis shows the range of p from 0 to p_upper and
the Y axis depicts both point estimates and the upper end point of the one-sided confidence intervals.
}
\description{
Plots upper bounds on relative and attributable risk
}
\examples{
# use the ACS_CC dataset included in the package.
  y = ciccr::ACS_CC$topincome
  t = ciccr::ACS_CC$baplus
  x = ciccr::ACS_CC$age
  results = cicc_RR(y, t, x)
  cicc_plot(results)

}
\references{
Jun, S.J. and Lee, S. (2020). Causal Inference in Case-Control Studies.
\url{https://arxiv.org/abs/2004.08318}.
}
