% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cicc.R
\name{cicc}
\alias{cicc}
\title{Causal Inference for Relative Risk}
\usage{
cicc(y, t, x, p_upper = 1L, cov_prob = 0.95, length = 20L)
}
\arguments{
\item{y}{n-dimensional vector of binary outcomes}

\item{t}{n-dimensional vector of binary treatments}

\item{x}{n by p matrix of covariates}

\item{p_upper}{a specified upper bound for the unknown true case probability (default = 1)}

\item{cov_prob}{parameter for coverage probability of a confidence interval (default = 0.95)}

\item{length}{specified length of a sequence from 0 to p_upper (default = 20)}
}
\value{
An S3 object of type "ciccr". The object has the following elements:
\item{est}{(length)-dimensional vector of the upper bounds on the average of log relative risk}
\item{se}{(length)-dimensional vector of pointwise standard errors}
\item{ci}{(length)-dimensional vector of the upper ends of pointwise confidence interval}
\item{pseq}{(length)-dimensional vector of a grid from 0 to p_upper}
}
\description{
Provides an upper bound on the average of log relative risk.
}
\examples{
# use the ACS dataset included in the package.
  y = ciccr::ACS$topincome
  t = ciccr::ACS$baplus
  x = ciccr::ACS$age
# The upper bound for Pr(y=1) is set as p_upper = 1 by default
# with the defaulty coverage probability of 0.95.
  cicc(y, t, x)
# The upper bound for Pr(y=1) is set as p_upper = 0.2
# with the coverage probablity of 0.99.
  cicc(y, t, x, 0.2, 0.99)
}
\references{
Sung Jae Jun and Sokbae Lee. Causal Inference in Case-Control Studies.
\url{https://arxiv.org/abs/2004.08318}.
}
