% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platemodel.R
\docType{class}
\name{platemodel-class}
\alias{platemodel-class}
\alias{platemodel}
\alias{initialize,platemodel-method}
\title{Class of objects representing plate tectonic models}
\usage{
\S4method{initialize}{platemodel}(.Object, path = NULL,
  rotation = NULL, polygons = NULL)
}
\arguments{
\item{.Object}{Virtual argument used for method dispatch.}

\item{path}{Path to a .mod unique plate model object.}

\item{rotation}{If \code{path} is \code{NULL}, the path to the rotation file-part of the model.}

\item{polygons}{If \code{path} is \code{NULL}, the path to the plate polygon file-part of the model.}
}
\value{
A \code{platemodel} class object.
}
\description{
Meta-object containing paths to a unique plate tectonic model
}
\examples{
# link to a single .mod file
\donttest{
	mo <- fetch("paleomap", "model", datadir="~")
 # manually attach model paths
	model <- platemodel(file.path(tempdir(), 
   "paleomap_model_v3-GPlates/paleomap_model_v3-GPlates.mod"))
}
}
